#! /bin/bash -p
#
# Generic ThinPrint Client Unix Uninstaller
# (c) 2007-2016 Cortado AG
#
uninst_VER='$7.0.$Revision: 31$'
#

if [ "$UID" -ne "$EUID" ]; then
   # We have been invoked by a set-UID process. Re-invoke
   # ourselves as sudo would have done it, i.e.:
   # - With the SUDO_UID environment variable set to the current UID.
   # - With the UID and EUID set to the current EUID.
   # This way the rest of this executable behaves consistently, regardless of
   # how the executable was invoked.
 
   export -- SUDO_UID="$UID"
   # To debug, it is very convenient to:
   # - Append -x to the line at the top of this file.
   # - Append >>/tmp/debug 2>&1 to the line below this comment.
   exec -- perl -XUe '$< = $>; exec(@ARGV)' -- "$0" "$@"
fi


cd "${0%/*}"
IFS="${IFS= 	}"; _ifs="$IFS"; IFS="${IFS}:"
read mv rv <<EOF
  $(IFS=$; echo $uninst_VER)
EOF
read vmaj vmin <<EOF
  $(IFS=.; echo $mv)
EOF
read z vrev <<EOF
  $(IFS=" "; echo $rv)
EOF
IFS="$_ifs"

if [ "$1" = "-v" ]; then
    echo "ThinPrint Client Unix Uninstall Version $vmaj.$vmin.$vrev, (c) 2007-2016 Cortado AG"
    exit 0
fi

if [ ! "$UID" = "0" ]; then
  echo root permission required!
  exit 1
fi

#
# echo PID to calling process
# this is required by VMware
#
echo $$


basename=
dirname=
pwd=
chmod=
chown=
cp=
mv=
rm=
mkdir=
ln=
find=
cat=
cut=
sed=
grep=
ldd=
cupsconfig=
restorecon=
osacompile=

IFS="${IFS= 	}"; y="$IFS"; IFS="${IFS}:"
for i in $PATH; do
  test -z "$i" && i=.
  if [ "$basename" = "" ] && [ -f $i/basename ]; then
    basename=$i/basename
  fi
  if [ "$dirname" = "" ] && [ -f $i/dirname ]; then
    dirname=$i/dirname
  fi
  if [ "$pwd" = "" ] && [ -f $i/pwd ]; then
    pwd=$i/pwd
  fi
  if [ "$chmod" = "" ] && [ -f $i/chmod ]; then
    chmod=$i/chmod
  fi
  if [ "$chown" = "" ] && [ -f $i/chown ]; then
    chown=$i/chown
  fi
  if [ "$cp" = "" ] && [ -f $i/cp ]; then
    cp=$i/cp
  fi
  if [ "$mv" = "" ] && [ -f $i/mv ]; then
    mv=$i/mv
  fi
  if [ "$rm" = "" ] && [ -f $i/rm ]; then
    rm=$i/rm
  fi
  if [ "$mkdir" = "" ] && [ -f $i/mkdir ]; then
    mkdir=$i/mkdir
  fi
  if [ "$ln" = "" ] && [ -f $i/ln ]; then
    ln=$i/ln
  fi
  if [ "$find" = "" ] && [ -f $i/find ]; then
    find=$i/find
  fi
  if [ "$cat" = "" ] && [ -f $i/cat ]; then
    cat=$i/cat
  fi
  if [ "$cut" = "" ] && [ -f $i/cut ]; then
    cut=$i/cut
  fi
  if [ "$sed" = "" ] && [ -f $i/sed ]; then
    sed=$i/sed
  fi
  if [ "$grep" = "" ] && [ -f $i/grep ]; then
    grep=$i/grep
  fi
  if [ "$ldd" = "" ] && [ -f $i/ldd ]; then
      ldd=$i/ldd
  fi
  if [ "$cupsconfig" = "" ] && [ -f $i/cups-config ]; then
    cupsconfig=$i/cups-config
  fi
  if [ "$restorecon" = "" ] && [ -f $i/restorecon ]; then
    restorecon=$i/restorecon
  fi
  if [ "$osacompile" = "" ] && [ -f $i/osacompile ]; then
    osacompile=$i/osacompile
  fi
done
IFS="$y"

if [ "$basename" = "" ]; then
  echo missing '"basename"' tool required for installation.
  exit 1
fi
if [ "$dirname" = "" ]; then
  echo missing '"dirname"' tool required for installation.
  exit 1
fi
if [ "$pwd" = "" ]; then
  echo missing '"pwd"' tool required for installation.
  exit 1
fi
if [ "$chmod" = "" ]; then
  echo missing '"chmod"' tool required for installation.
  exit 1
fi
if [ "$chown" = "" ]; then
  echo missing '"chown"' tool required for installation.
  exit 1
fi
if [ "$cp" = "" ]; then
  echo missing '"cp"' tool required for installation.
  exit 1
fi
if [ "$mv" = "" ]; then
  echo missing '"mv"' tool required for installation.
  exit 1
fi
if [ "$rm" = "" ]; then
  echo missing '"rm"' tool required for installation.
  exit 1
fi
if [ "$mkdir" = "" ]; then
  echo missing '"mkdir"' tool required for installation.
  exit 1
fi
if [ "$ln" = "" ]; then
  echo missing '"ln"' tool required for installation.
  exit 1
fi
if [ "$find" = "" ]; then
  echo missing '"find"' tool required for installation.
  exit 1
fi
if [ "$cat" = "" ]; then
  echo missing '"cat"' tool required for installation.
  exit 1
fi
if [ "$cut" = "" ]; then
  echo missing '"cut"' tool required for installation.
  exit 1
fi
if [ "$sed" = "" ]; then
  echo missing '"sed"' tool required for installation.
  exit 1
fi
if [ "$grep" = "" ]; then
  echo missing '"grep"' tool required for installation.
  exit 1
fi

# if there is only one target architecture, then select this one automatically
archlst=`for u in *; do if [ -d "$u" ] && [ ! "$u" = "conf" ] && [ ! "$u" = "init.d" ]; then echo $u; fi; done`
[ ! "$arch" = "" ] || [ ! -d "$archlst" ] || arch="$archlst"

vmaj=`cat rev.rc | cut -d. -f1`
vmin=`cat rev.rc | cut -d. -f2`
vrev=`cat rev.rc | cut "-d$" -f2 | cut "-d " -f2`
let version=$vmaj*10000000+$vmin*100000+$vrev
sys=`uname -s`
sysv=`uname -r`
sysmaj=`echo $sysv | cut -d. -f1`
sysmin=`echo $sysv | cut -d. -f2`
sysrev=`echo $sysv | cut -d. -f3`
mach=`uname -m`

# OS Release Files
#
# Annvix: /etc/annvix-release
# Arch Linux: /etc/arch-release
# Arklinux: /etc/arklinux-release
# Aurox Linux: /etc/aurox-release
# BlackCat: /etc/blackcat-release
# Cobalt: /etc/cobalt-release
# Conectiva: /etc/conectiva-release
# Debian: /etc/debian_version, /etc/debian_release (rare)
# Fedora Core: /etc/fedora-release
# Gentoo Linux: /etc/gentoo-release
# Immunix: /etc/immunix-release
# Knoppix: /etc/knoppix_version
# Linux-From-Scratch: /etc/lfs-release
# Linux-PPC: /etc/linuxppc-release
# Mandrake: /etc/mandrake-release
# Mandriva/Mandrake Linux: /etc/mandriva-release, /etc/mandrake-release, /etc/mandrakelinux-release
# MkLinux: /etc/mklinux-release
# Novell Linux Desktop: /etc/nld-release
# PLD Linux: /etc/pld-release
# Red Hat: /etc/redhat-release, /etc/redhat_version (rare)
# Slackware: /etc/slackware-version, /etc/slackware-release (rare)
# SME Server (Formerly E-Smith): /etc/e-smith-release
# Solaris SPARC: /etc/release
# Sun JDS: /etc/sun-release
# SUSE Linux: /etc/SuSE-release, /etc/novell-release
# SUSE Linux ES9: /etc/sles-release
# Tiny Sofa: /etc/tinysofa-release
# TurboLinux: /etc/turbolinux-release
# Ubuntu Linux: /etc/lsb-release
# UltraPenguin: /etc/ultrapenguin-release
# UnitedLinux: /etc/UnitedLinux-release (covers SUSE SLES8)
# VA-Linux/RH-VALE: /etc/va-release
# Yellow Dog: /etc/yellowdog-release
# Darwin (Mac OS): /System/Library/CoreServices/SystemVersion.plist
#
sysrel_flst="/etc/annvix-release /etc/arch-release /etc/arklinux-release /etc/aurox-release /etc/blackcat-release /etc/cobalt-release /etc/conectiva-release /etc/debian_version /etc/debian_release /etc/fedora-release /etc/gentoo-release /etc/immunix-release /etc/knoppix_version /etc/lfs-release /etc/linuxppc-release /etc/mandrake-release /etc/mandriva-release /etc/mandrake-release /etc/mandrakelinux-release /etc/mklinux-release /etc/nld-release /etc/pld-release /etc/redhat-release /etc/redhat_version /etc/slackware-version /etc/slackware-release /etc/e-smith-release /etc/release /etc/sun-release /etc/SuSE-release /etc/novell-release /etc/sles-release /etc/tinysofa-release /etc/turbolinux-release /etc/lsb-release /etc/ultrapenguin-release /etc/UnitedLinux-release /etc/va-release /etc/yellowdog-release /System/Library/CoreServices/SystemVersion.plist"

case "$mach-$sys" in
    x86_64-Linux)
	so=.so
        etc=/etc
        initd=/etc/init.d
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib64
        [ -d $lib ] || lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        elif [ -d /usr/lib64/cups ]; then
            cupsbin=/usr/lib64/cups
        else
            cupsbin=/usr/lib/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
        [ ! "$arch" = "" ] || arch=x86_64-linux
        ;;
    i*86-Linux)
	so=.so
        etc=/etc
        initd=/etc/init.d
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        else
            cupsbin=/usr/lib/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
        [ ! "$arch" = "" ] || arch=i586-linux
        ;;
    armv6l-Linux | armv7l-Linux)
	so=.so
        etc=/etc
        initd=/etc/init.d
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        else
            cupsbin=/usr/lib/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
        [ ! "$arch" = "" ] || arch=armv6l-linux
        ;;
    i*86-Darwin | x86-Darwin)
        ldd=
	so=.dylib
        pwd="$pwd -P"
        etc=/etc
        initd=/System/Library/LaunchDaemons
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        else
            cupsbin=/usr/libexec/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
	if [ $sysmaj -ge 10 ]; then
            [ ! "$arch" = "" ] || arch=x86_64-darwin
	else
            [ ! "$arch" = "" ] || arch=i386-darwin
	fi
        ;;
    x86_64-Darwin)
        ldd=
	so=.dylib
        pwd="$pwd -P"
        etc=/etc
        initd=/System/Library/LaunchDaemons
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        else
            cupsbin=/usr/libexec/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
        [ ! "$arch" = "" ] || arch=x86_64-darwin
        ;;
    "Power Macintosh-Darwin")
        ldd=
	so=.dylib
        pwd="$pwd -P"
        etc=/etc
        initd=/System/Library/LaunchDaemons
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        else
            cupsbin=/usr/libexec/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
        [ ! "$arch" = "" ] || arch=ppc-darwin
        ;;
    *)
        echo target $mach-$sys not supported.
        exit 1
        ;;
esac

function svcreload
{
    local ps=`ps ax | grep $1 | grep -v grep`
    local pid
    for pid in $ps; do
	kill -SIGHUP $pid
	break
    done
}

if [ "$mach"-"$sys"-"$sysv" = "x86-Darwin-8.0.1" ] && [ -d i386-darwin ]; then
    if ! cat i386-darwin/build.spec | grep "Darwin Kernel Version 8.0.1" | grep "x86" > /dev/null 2>&1; then
        echo binary re-patch supported for opensource darwin 8.0.1 builds only.
        exit 1
    fi
    for file in .thnumod thnuclnt thnuclntd thnuconf thnuchk thnucups thnurdp; do
        i=`xxd -c1 i386-darwin/$file | tr '\n' ' '| grep -o -e '[a-f0-9]*:[ ]*05[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*50[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*01[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*10[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]00[ ]*.' | cut -d: -f1`
        if [ ! "$i" = "" ]; then
            echo $i: 0500000050000000ffffffff | xxd -r - i386-darwin/$file
        fi
    done
fi

case "$arch" in
    *-vmAppLd*)
	echo architecture "*-vmAppLd*" not suitable for uninstall.
	exit 1
	;;
    *)
	r=

	# special os releases take precedence
	v=
	case "$mach-$sys" in
	    i*86-Linux|x86_64-Linux)
		if [ -a /etc/fedora-release ] || [ -a /etc/redhat-release ] || [ -a /etc/redhat_version ]; then
		    v="$arch-RHEL5 $arch-RHEL6"
		else
		    v="$arch-SSL098 $arch-SSL100"
		fi
		;;
	    armv6l-Linux|armv7l-Linux)
		v="$arch-SSL098 $arch-SSL100"
		;;
	    i*86-Darwin|x86-Darwin)
		v="x86_64-darwin"
		;;
	esac
	for i in $v; do
	    [ ! -d $i ] || [ "$debug" = "" ] || [ "$ldd" = "" ] || { echo $i: ; $ldd $i/thnuclnt | grep "not found" ; }
	    if [ -d $i ] && $i/thnuclnt -v > /dev/null 2>&1; then
		arch=$i
		r=1
		break
	    fi
	done
	
	[ "$r" = "1" ] || [ ! -d $arch ] || [ "$debug" = "" ] || [ "$ldd" = "" ] || { echo $arch: ; $ldd $arch/thnuclnt | grep "not found" ; }
	if [ -d $arch ] && $arch/thnuclnt -v > /dev/null 2>&1; then
	    r=1
	elif [ -d $arch/static ] && $arch/static/thnuclnt -v > /dev/null 2>&1; then
	    arch=$arch/static
	    r=1
	elif [ -d $arch-NOSSL ] && $arch-NOSSL/thnuclnt -v > /dev/null 2>&1; then
	    arch=$arch-NOSSL
	    r=1
	fi
	
	if [ "$r" = "" ]; then
	    case "$arch" in
		i586-linux|x86_64-linux)
		    case "$mach-$sys" in
			i*86-Linux|x86_64-Linux)
			    if [ -d i586-linux-archaic/static ] && i586-linux-archaic/static/thnuclnt -v > /dev/null 2>&1; then
				arch=i586-linux-archaic/static
				r=1
			    fi
			    ;;
		    esac
		    ;;
	    esac
	fi
	;;
esac

if [ ! -d $arch ]; then
    echo architecture $arch not available for uninstall.
    exit 1
fi

echo arch=$arch selected.

if [ ! -f $lib/thnuclnt/rev.rc ]; then
   exit 0
fi
oldvmaj=`cat $lib/thnuclnt/rev.rc | cut -d. -f1`
oldvmin=`cat $lib/thnuclnt/rev.rc | cut -d. -f2`
oldvrev=`cat $lib/thnuclnt/rev.rc | cut "-d$" -f2 | cut "-d " -f2`
let oldver=$oldvmaj*10000000+$oldvmin*100000+$oldvrev
echo uninstalling $oldvmaj.$oldvmin.$oldvrev ...

case "$sys" in
    Linux)
        for rcd in rcS.d rc0.d rc1.d rc2.d rc3.d rc4.d rc5.d rc6.d; do
            for d in /etc /etc/rc.d; do
                if [ -d $d/$rcd ]; then
                    for f in `echo $d/$rcd/* | grep -o -e ...thnuclnt`; do
                        rm -f $d/$rcd/$f
                    done
                fi
            done
        done
        initdrc=$initd/thnuclnt
        if [ -f $initdrc ]; then
            $initdrc stop > /dev/null 2>&1
        fi
        ;;
    Darwin)
        initdrc=$initd/thnuclnt.plist
        if [ -f $initdrc ]; then
            service thnuclnt stop > /dev/null 2>&1
        fi
        ;;
    *)
        echo target $mach-$sys not supported
        exit 1
        ;;
esac

manifest=`cat $lib/thnuclnt/Manifest`
for nd in $initdrc $etc/thnuclnt $cupsroot/thnuclnt.convs $cupsroot/thnuclnt.types $sbin/thnuclntd $bin/thnuclnt $bin/thnuconf $bin/thnuchk $cupsbin/filter/thnucups $lib/thnuclnt $manifest; do
    if [ -d $nd ] || [ -L $nd ] || [ -f $nd ]; then
	if [ "$nd" = "$etc/thnuclnt" ] || [ "$nd" = "$etc/thnuclnt/thnuclnt.conf" ]; then
	    # keep global configuration file /etc/thnuclnt/thnuclnt.conf
	    :
	elif [ "$nd" = "$cupsroot/thnuclnt.convs" ] || [ "$nd" = "$cupsroot/thnuclnt.types" ]; then
	    # keep global CUPS reference installed,
	    # to support further private installations they may share these references.
	    if [ -L $nd ]; then
		cp conf/`basename $nd` $nd-$PPID
		mv -f $nd-$PPID $nd
	    fi
	elif [ "$nd" = "$cupsbin/filter/thnucups" ]; then
	    # keep global CUPS reference installed,
	    # to support further private installations they may share these references.
	    if [ -L $nd ] || file $nd | grep "shell script" > /dev/null 2>&1; then
		cp $arch/thnucups $nd-$PPID
		mv -f $nd-$PPID $nd
	    fi
	else
            rm -rf $nd
	fi
    fi
done

case "$sys" in
    Linux)
        if [ "false" = "" ]; then
            if [ -f $initd/cupsys ]; then
		cupsys=$initd/cupsys
            fi
            if [ -f $initd/cups ]; then
		cupsys=$initd/cups
            fi
            if [ -f $cupsys ]; then
		if $cupsys status; then
                    $cupsys restart
		fi
            fi
	else
	    svcreload cupsd
	fi
        ;;
    Darwin)
        if [ "false" = "" ]; then
	    # ATT: works for old Darwin os, but not for current!
            SystemStarter restart PrintingServices
	else
	    svcreload cupsd
	fi
        ;;
    *)
        echo target $mach-$sys not supported
        exit 1
        ;;
esac


echo done.
