#! /bin/bash -p
#
# Generic ThinPrint Client Unix Setup
# (c) 2007-2016 Cortado AG
#
setup_VER='$7.0.$Revision: 97$'
#
# TODO:
# - thnuclnt binary selftest before installation
#

if [ "$UID" -ne "$EUID" ]; then
   # We have been invoked by a set-UID process. Re-invoke
   # ourselves as sudo would have done it, i.e.:
   # - With the SUDO_UID environment variable set to the current UID.
   # - With the UID and EUID set to the current EUID.
   # This way the rest of this executable behaves consistently, regardless of
   # how the executable was invoked.
 
   export -- SUDO_UID="$UID"
   # To debug, it is very convenient to:
   # - Append -x to the line at the top of this file.
   # - Append >>/tmp/debug 2>&1 to the line below this comment.
   exec -- perl -XUe '$< = $>; exec(@ARGV)' -- "$0" "$@"
fi


cd "${0%/*}"
IFS="${IFS= 	}"; _ifs="$IFS"; IFS="${IFS}:"
read mv rv <<EOF
  $(IFS=$; echo $setup_VER)
EOF
read vmaj vmin <<EOF
  $(IFS=.; echo $mv)
EOF
read z vrev <<EOF
  $(IFS=" "; echo $rv)
EOF
IFS="$_ifs"

if [ "$1" = "-v" ]; then
    echo "ThinPrint Client Unix Setup Version $vmaj.$vmin.$vrev, (c) 2007-2016 Cortado AG"
    exit 0
fi

if [ ! "$UID" = "0" ]; then
  echo root permission required!
  exit 1
fi

#
# echo PID to calling process
# this is required by VMware
#
echo $$


basename=
dirname=
pwd=
chmod=
chown=
cp=
mv=
rm=
mkdir=
ln=
find=
cat=
cut=
sed=
grep=
ldd=
cupsconfig=
restorecon=
osacompile=

IFS="${IFS= 	}"; y="$IFS"; IFS="${IFS}:"
for i in $PATH; do
  test -z "$i" && i=.
  if [ "$basename" = "" ] && [ -f $i/basename ]; then
    basename=$i/basename
  fi
  if [ "$dirname" = "" ] && [ -f $i/dirname ]; then
    dirname=$i/dirname
  fi
  if [ "$pwd" = "" ] && [ -f $i/pwd ]; then
    pwd=$i/pwd
  fi
  if [ "$chmod" = "" ] && [ -f $i/chmod ]; then
    chmod=$i/chmod
  fi
  if [ "$chown" = "" ] && [ -f $i/chown ]; then
    chown=$i/chown
  fi
  if [ "$cp" = "" ] && [ -f $i/cp ]; then
    cp=$i/cp
  fi
  if [ "$mv" = "" ] && [ -f $i/mv ]; then
    mv=$i/mv
  fi
  if [ "$rm" = "" ] && [ -f $i/rm ]; then
    rm=$i/rm
  fi
  if [ "$mkdir" = "" ] && [ -f $i/mkdir ]; then
    mkdir=$i/mkdir
  fi
  if [ "$ln" = "" ] && [ -f $i/ln ]; then
    ln=$i/ln
  fi
  if [ "$find" = "" ] && [ -f $i/find ]; then
    find=$i/find
  fi
  if [ "$cat" = "" ] && [ -f $i/cat ]; then
    cat=$i/cat
  fi
  if [ "$cut" = "" ] && [ -f $i/cut ]; then
    cut=$i/cut
  fi
  if [ "$sed" = "" ] && [ -f $i/sed ]; then
    sed=$i/sed
  fi
  if [ "$grep" = "" ] && [ -f $i/grep ]; then
    grep=$i/grep
  fi
  if [ "$ldd" = "" ] && [ -f $i/ldd ]; then
      ldd=$i/ldd
  fi
  if [ "$cupsconfig" = "" ] && [ -f $i/cups-config ]; then
    cupsconfig=$i/cups-config
  fi
  if [ "$restorecon" = "" ] && [ -f $i/restorecon ]; then
    restorecon=$i/restorecon
  fi
  if [ "$osacompile" = "" ] && [ -f $i/osacompile ]; then
    osacompile=$i/osacompile
  fi
done
IFS="$y"

if [ "$basename" = "" ]; then
  echo missing '"basename"' tool required for installation.
  exit 1
fi
if [ "$dirname" = "" ]; then
  echo missing '"dirname"' tool required for installation.
  exit 1
fi
if [ "$pwd" = "" ]; then
  echo missing '"pwd"' tool required for installation.
  exit 1
fi
if [ "$chmod" = "" ]; then
  echo missing '"chmod"' tool required for installation.
  exit 1
fi
if [ "$chown" = "" ]; then
  echo missing '"chown"' tool required for installation.
  exit 1
fi
if [ "$cp" = "" ]; then
  echo missing '"cp"' tool required for installation.
  exit 1
fi
if [ "$mv" = "" ]; then
  echo missing '"mv"' tool required for installation.
  exit 1
fi
if [ "$rm" = "" ]; then
  echo missing '"rm"' tool required for installation.
  exit 1
fi
if [ "$mkdir" = "" ]; then
  echo missing '"mkdir"' tool required for installation.
  exit 1
fi
if [ "$ln" = "" ]; then
  echo missing '"ln"' tool required for installation.
  exit 1
fi
if [ "$find" = "" ]; then
  echo missing '"find"' tool required for installation.
  exit 1
fi
if [ "$cat" = "" ]; then
  echo missing '"cat"' tool required for installation.
  exit 1
fi
if [ "$cut" = "" ]; then
  echo missing '"cut"' tool required for installation.
  exit 1
fi
if [ "$sed" = "" ]; then
  echo missing '"sed"' tool required for installation.
  exit 1
fi
if [ "$grep" = "" ]; then
  echo missing '"grep"' tool required for installation.
  exit 1
fi

# if there is only one target architecture, then select this one automatically
archlst=`for u in *; do if [ -d "$u" ] && [ ! "$u" = "conf" ] && [ ! "$u" = "init.d" ]; then echo $u; fi; done`
[ ! "$arch" = "" ] || [ ! -d "$archlst" ] || arch="$archlst"

vmaj=`cat rev.rc | cut -d. -f1`
vmin=`cat rev.rc | cut -d. -f2`
vrev=`cat rev.rc | cut "-d$" -f2 | cut "-d " -f2`
let version=$vmaj*10000000+$vmin*100000+$vrev
sys=`uname -s`
sysv=`uname -r`
sysmaj=`echo $sysv | cut -d. -f1`
sysmin=`echo $sysv | cut -d. -f2`
sysrev=`echo $sysv | cut -d. -f3`
mach=`uname -m`
# version shift option.
# preserves former binary versions from being deleted.
vshift=0
# CUPS thnuclnt version (detection later)
vcups=0
# running service detect flag.
svc=0

# OS Release Files
#
# Annvix: /etc/annvix-release
# Arch Linux: /etc/arch-release
# Arklinux: /etc/arklinux-release
# Aurox Linux: /etc/aurox-release
# BlackCat: /etc/blackcat-release
# Cobalt: /etc/cobalt-release
# Conectiva: /etc/conectiva-release
# Debian: /etc/debian_version, /etc/debian_release (rare)
# Fedora Core: /etc/fedora-release
# Gentoo Linux: /etc/gentoo-release
# Immunix: /etc/immunix-release
# Knoppix: /etc/knoppix_version
# Linux-From-Scratch: /etc/lfs-release
# Linux-PPC: /etc/linuxppc-release
# Mandrake: /etc/mandrake-release
# Mandriva/Mandrake Linux: /etc/mandriva-release, /etc/mandrake-release, /etc/mandrakelinux-release
# MkLinux: /etc/mklinux-release
# Novell Linux Desktop: /etc/nld-release
# PLD Linux: /etc/pld-release
# Red Hat: /etc/redhat-release, /etc/redhat_version (rare)
# Slackware: /etc/slackware-version, /etc/slackware-release (rare)
# SME Server (Formerly E-Smith): /etc/e-smith-release
# Solaris SPARC: /etc/release
# Sun JDS: /etc/sun-release
# SUSE Linux: /etc/SuSE-release, /etc/novell-release
# SUSE Linux ES9: /etc/sles-release
# Tiny Sofa: /etc/tinysofa-release
# TurboLinux: /etc/turbolinux-release
# Ubuntu Linux: /etc/lsb-release
# UltraPenguin: /etc/ultrapenguin-release
# UnitedLinux: /etc/UnitedLinux-release (covers SUSE SLES8)
# VA-Linux/RH-VALE: /etc/va-release
# Yellow Dog: /etc/yellowdog-release
# Darwin (Mac OS): /System/Library/CoreServices/SystemVersion.plist
#
sysrel_flst="/etc/annvix-release /etc/arch-release /etc/arklinux-release /etc/aurox-release /etc/blackcat-release /etc/cobalt-release /etc/conectiva-release /etc/debian_version /etc/debian_release /etc/fedora-release /etc/gentoo-release /etc/immunix-release /etc/knoppix_version /etc/lfs-release /etc/linuxppc-release /etc/mandrake-release /etc/mandriva-release /etc/mandrake-release /etc/mandrakelinux-release /etc/mklinux-release /etc/nld-release /etc/pld-release /etc/redhat-release /etc/redhat_version /etc/slackware-version /etc/slackware-release /etc/e-smith-release /etc/release /etc/sun-release /etc/SuSE-release /etc/novell-release /etc/sles-release /etc/tinysofa-release /etc/turbolinux-release /etc/lsb-release /etc/ultrapenguin-release /etc/UnitedLinux-release /etc/va-release /etc/yellowdog-release /System/Library/CoreServices/SystemVersion.plist"

case "$mach-$sys" in
    x86_64-Linux)
	so=.so
        etc=/etc
        initd=/etc/init.d
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib64
        [ -d $lib ] || lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        elif [ -d /usr/lib64/cups ]; then
            cupsbin=/usr/lib64/cups
        else
            cupsbin=/usr/lib/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
        [ ! "$arch" = "" ] || arch=x86_64-linux
        ;;
    i*86-Linux)
	so=.so
        etc=/etc
        initd=/etc/init.d
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        else
            cupsbin=/usr/lib/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
        [ ! "$arch" = "" ] || arch=i586-linux
        ;;
    armv6l-Linux | armv7l-Linux)
	so=.so
        etc=/etc
        initd=/etc/init.d
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        else
            cupsbin=/usr/lib/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
        [ ! "$arch" = "" ] || arch=armv6l-linux
        ;;
    i*86-Darwin | x86-Darwin)
        ldd=
	so=.dylib
        pwd="$pwd -P"
        etc=/etc
        initd=/System/Library/LaunchDaemons
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        else
            cupsbin=/usr/libexec/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
	if [ $sysmaj -ge 10 ]; then
            [ ! "$arch" = "" ] || arch=x86_64-darwin
	else
            [ ! "$arch" = "" ] || arch=i386-darwin
	fi
        ;;
    x86_64-Darwin)
        ldd=
	so=.dylib
        pwd="$pwd -P"
        etc=/etc
        initd=/System/Library/LaunchDaemons
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        else
            cupsbin=/usr/libexec/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
        [ ! "$arch" = "" ] || arch=x86_64-darwin
        ;;
    "Power Macintosh-Darwin")
        ldd=
	so=.dylib
        pwd="$pwd -P"
        etc=/etc
        initd=/System/Library/LaunchDaemons
        sbin=/usr/sbin
        bin=/usr/bin
        lib=/usr/lib
        if [ ! "$cupsconfig" = "" ]; then
            cupsbin=`$cupsconfig --serverbin`
        else
            cupsbin=/usr/libexec/cups
        fi
        if [ ! "$cupsconfig" = "" ]; then
            cupsroot=`$cupsconfig --serverroot`
        elif [ -d /etc/cups ]; then
            cupsroot=/etc/cups
        fi
        [ ! "$arch" = "" ] || arch=ppc-darwin
        ;;
    *)
        echo target $mach-$sys not supported.
        exit 1
        ;;
esac

function relpath ()
{
    IFS="${IFS= 	}"
    local _ifs="$IFS"
    local file="$1"
    local base=${2:-$($pwd)}
    [[ "$base" != */ ]] && base=${base}/
    
    declare -a afile abase
    IFS=/ afile=( $file )
    IFS=/ abase=( $base )
    
    local common=
    for ((lvl=1; lvl < ${#afile[*]}; lvl++))
      do
      [ "${afile[lvl]}" != "${abase[lvl]}" ] && break
      common=$common/${afile[lvl]}
    done
    
    file=${file#$common/}
    base=${base#$common/}
    
    local extglob=$(shopt -p extglob)
    shopt -s extglob
    up=${base//+([^\/])\//../}
    [ -z "$up" ] && up=./
    eval $extglob
    
    echo "${up}${file}"
    IFS="$_ifs"
}

function svcreload
{
    local ps=`ps ax | grep $1 | grep -v grep`
    local pid
    for pid in $ps; do
	kill -SIGHUP $pid
	break
    done
}

for d in $etc $initd $sbin $bin $lib; do
    if [ ! -d $d ]; then
        echo missing '"'$d'"' system directory required for installation.
        exit 1
    fi
done

cwd=`pwd`

cd $etc
etclib=`relpath $lib`
cd $initd
initdlib=`relpath $lib`
cd $sbin
sbinlib=`relpath $lib`
cd $bin
binlib=`relpath $lib`
cd "$cwd"

if [ "$mach"-"$sys"-"$sysv" = "x86-Darwin-8.0.1" ] && [ -d i386-darwin ]; then
    if ! cat i386-darwin/build.spec | grep "Darwin Kernel Version 8.0.1" | grep "x86" > /dev/null 2>&1; then
        echo binary re-patch supported for opensource darwin 8.0.1 builds only.
        exit 1
    fi
    for file in .thnumod thnuclnt thnuclntd thnuconf thnuchk thnucups thnurdp; do
        i=`xxd -c1 i386-darwin/$file | tr '\n' ' '| grep -o -e '[a-f0-9]*:[ ]*05[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*50[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*01[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*10[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]*00[ ]*.[ ]*[a-f0-9]*:[ ]00[ ]*.' | cut -d: -f1`
        if [ ! "$i" = "" ]; then
            echo $i: 0500000050000000ffffffff | xxd -r - i386-darwin/$file
        fi
    done
fi

case "$arch" in
    *-vmAppLd*)
	appld=$arch/vmappld
	x=$so
	
	# no version shifting, that gets too complicate
	vshift=0
	;;
    *)
	appld=
	x=
	r=

	# special os releases take precedence
	v=
	case "$mach-$sys" in
	    i*86-Linux|x86_64-Linux)
		if [ -a /etc/fedora-release ] || [ -a /etc/redhat-release ] || [ -a /etc/redhat_version ]; then
		    v="$arch-RHEL6 $arch-RHEL5"
		else
		    v="$arch-SSL100 $arch-SSL098"
		fi
		;;
	    armv6l-Linux|armv7l-Linux)
		v="$arch-SSL100 $arch-SSL098"
		;;
	    i*86-Darwin|x86-Darwin)
		v="x86_64-darwin x86_64-darwin-tiger"
		;;
	esac
	for i in $v; do
	    [ ! -d $i ] || [ "$debug" = "" ] || [ "$ldd" = "" ] || { echo $i: ; $ldd $i/thnuclnt | grep "not found" ; }
	    if [ -d $i ] && $i/thnuclnt -v > /dev/null 2>&1; then
		arch=$i
		r=1
		break
	    fi
	done
	
	[ "$r" = "1" ] || [ ! -d $arch ] || [ "$debug" = "" ] || [ "$ldd" = "" ] || { echo $arch: ; $ldd $arch/thnuclnt | grep "not found" ; }
	if [ -d $arch ] && $arch/thnuclnt -v > /dev/null 2>&1; then
	    r=1
	elif [ -d $arch/static ] && $arch/static/thnuclnt -v > /dev/null 2>&1; then
	    arch=$arch/static
	    r=1
	elif [ -d $arch-NOSSL ] && $arch-NOSSL/thnuclnt -v > /dev/null 2>&1; then
	    arch=$arch-NOSSL
	    r=1
	fi
	
	if [ "$r" = "" ]; then
	    case "$arch" in
		i586-linux|x86_64-linux)
		    case "$mach-$sys" in
			i*86-Linux|x86_64-Linux)
			    if [ -d i586-linux-archaic/static ] && i586-linux-archaic/static/thnuclnt -v > /dev/null 2>&1; then
				arch=i586-linux-archaic/static
				r=1
			    fi
			    ;;
		    esac
		    ;;
	    esac
	fi
	;;
esac

if [ ! -d $arch ]; then
    echo architecture $arch not available for installation.
    exit 1
fi

echo arch=$arch selected.

if ! $appld $arch/thnuclnt$x -v > /dev/null 2>&1; then
    $appld $arch/thnuclnt$x -v > /dev/null
    exit 1
fi

if $appld $arch/thnuclnt$x -V | grep CUPS > /dev/null 2>&1; then
    vcups=1
    if [ ! -d $cupsroot ]; then
        echo failed to detect CUPS '"serverroot"' directory required for installation.
        exit 1
    fi
    if [ ! -d $cupsbin ]; then
        echo failed to detect CUPS '"serverbin"' directory required for installation.
        exit 1
    fi
fi

if [ -f $lib/thnuclnt/rev.rc ]; then
    oldvmaj=`cat $lib/thnuclnt/rev.rc | cut -d. -f1`
    oldvmin=`cat $lib/thnuclnt/rev.rc | cut -d. -f2`
    oldvrev=`cat $lib/thnuclnt/rev.rc | cut "-d$" -f2 | cut "-d " -f2`
    let oldver=$oldvmaj*10000000+$oldvmin*100000+$oldvrev
    if [ $oldver -ge $version ]; then
        echo $oldvmaj.$oldvmin.$oldvrev installed already.
        exit 0
    else
        echo upgrading to $vmaj.$vmin.$vrev ...
    fi
else
    echo installing $vmaj.$vmin.$vrev ...
fi

mkdir -p $etc/thnuclnt
mkdir -p $lib/thnuclnt/bin
mkdir -p $lib/thnuclnt/init.d
mkdir -p $lib/thnuclnt/conf
echo $etc/thnuclnt > $lib/thnuclnt/Manifest-$PPID
echo $lib/thnuclnt >> $lib/thnuclnt/Manifest-$PPID
echo $lib/thnuclnt/bin >> $lib/thnuclnt/Manifest-$PPID
echo $lib/thnuclnt/init.d >> $lib/thnuclnt/Manifest-$PPID
echo $lib/thnuclnt/conf >> $lib/thnuclnt/Manifest-$PPID
echo $lib/thnuclnt/Manifest >> $lib/thnuclnt/Manifest-$PPID
if [ -L $etc/thnuclnt/.thnumod ]; then
    oldv=`$etc/thnuclnt/.thnumod -v | sed -e "s/Version /,/" | cut -d, -f2`
    [ "$vshift" = "0" ] || echo $lib/thnuclnt/bin/.thnumod-$oldv >> $lib/thnuclnt/Manifest-$PPID
fi
cat > $etc/thnuclnt/.thnumod-$PPID <<EOF
#! /bin/sh
exit 0
EOF
chmod 755 $etc/thnuclnt/.thnumod-$PPID
mv -f $etc/thnuclnt/.thnumod-$PPID $etc/thnuclnt/.thnumod
if [ -f /etc/redhat-release ] && [ ! "$restorecon" = "" ]; then
    restorecon $etc/thnuclnt/.thnumod
fi

for file in thnuclnt.convs thnuclnt.types; do
    v=`cat conf/$file | grep "$""Revision: " | sed -e "s/""\$""Revision: //" | cut "-d$" -f2`
    echo $lib/thnuclnt/conf/$file-$v >> $lib/thnuclnt/Manifest-$PPID
    if [ -d $cupsroot ]; then
        echo $cupsroot/$file >> $lib/thnuclnt/Manifest-$PPID
    fi
    if [ ! -f $lib/thnuclnt/conf/$file-$v ]; then
        cp conf/$file $lib/thnuclnt/conf/$file-$v
        chmod 444 $lib/thnuclnt/conf/$file-$v
	if [ -d $cupsroot ]; then
	    # 07/02/13 new strategy:
	    # we always install a copy to CUPS config directory,
	    # either as hard link or as true copy, as we want to keep
	    # these global references installed when uninstalling.
	    if ! ln -f $lib/thnuclnt/conf/$file-$v $cupsroot/$file-$PPID; then
		cp $lib/thnuclnt/conf/$file-$v $cupsroot/$file-$PPID
	    fi
            mv -f $cupsroot/$file-$PPID $cupsroot/$file
	fi
    elif [ -d $cupsroot ] && [ -L $cupsroot/$file ]; then
	# fix old symlinks to copies
	if ! ln -f $lib/thnuclnt/conf/$file-$v $cupsroot/$file-$PPID; then
	    cp $lib/thnuclnt/conf/$file-$v $cupsroot/$file-$PPID
	fi
        mv -f $cupsroot/$file-$PPID $cupsroot/$file
    fi
done

if [ ! "$appld" = "" ]; then
    file=$lib/thnuclnt/bin/`basename $appld`
    echo $file >> $lib/thnuclnt/Manifest-$PPID
    if [ ! -f $file ]; then
	cp $appld $file-$PPID
	chmod 4755 $file-$PPID
	mv -f $file-$PPID $file
    fi
fi

for file in thnuclnt thnuconf thnuchk thnucups thnurdp thnuclnt-ldstatic; do
    if [ -f $arch/$file ]; then
	image=$file
    else
	if [ -f $arch/$file$x ]; then
	    image=$file$x
	else
	    continue;
	fi
    fi
    v=`$appld $arch/$image -v | sed -e "s/Version /,/" | cut -d, -f2`
    if [ "$file" = "thnuclnt" ]; then
        xv=$v
    fi
    echo $lib/thnuclnt/bin/$file-$v >> $lib/thnuclnt/Manifest-$PPID
    if [ "$file" = "thnuclnt" ] && [ ! "$file" = "$image" ]; then
	echo $lib/thnuclnt/bin/$file-$v$x >> $lib/thnuclnt/Manifest-$PPID
    fi
    instd=$bin
    [ ! "$file" = "thnucups" ] || instd=$cupsbin/filter
    if [ -d $instd ]; then
        echo $instd/$file >> $lib/thnuclnt/Manifest-$PPID
    fi
    if [ -f $lib/thnuclnt/bin/$file-$v ]; then
	case "$file" in
	    thnuclnt)
		if [ "$file" = "$image" ] || [ -f $lib/thnuclnt/bin/$file-$v$x ]; then
		    continue
		fi
		;;
	    thnuclnt-ldstatic)
		continue
		;;
	    thnucups)
		# nowadays filter binary gets installed separately.
		# in former times this reference was a link to thnuclnt.
		if [ -L $lib/thnuclnt/bin/$file-$v ]; then
		    if [ "$image" = "$file" ]; then
			cp $arch/$image $lib/thnuclnt/bin/$file-$PPID
			chmod 755 $lib/thnuclnt/bin/$file-$PPID
			mv -f $lib/thnuclnt/bin/$file-$PPID $lib/thnuclnt/bin/$file-$v
		    else
			ln -f $lib/thnuclnt/bin/thnuclnt-$xv $lib/thnuclnt/bin/$file-$v
		    fi
		fi
		continue
		;;
	    *)
		ln -sf thnuclnt-$xv $lib/thnuclnt/bin/$file-$PPID
		mv -f $lib/thnuclnt/bin/$file-$PPID $lib/thnuclnt/bin/$file-$v
		continue
		;;
	esac
    fi
    if [ -L $instd/$file ]; then
        oldv=`$instd/$file -v | sed -e "s/Version /,/" | cut -d, -f2`
        [ "$vshift" = "0" ] || echo $lib/thnuclnt/bin/$file-$oldv >> $lib/thnuclnt/Manifest-$PPID
    fi
    case "$file" in
	thnuclnt)
	    cp $arch/$image $lib/thnuclnt/bin/$file-$v$x
	    if [ "$image" = "$file" ]; then
		chmod 4755 $lib/thnuclnt/bin/$file-$v$x
	    else
		chmod 755 $lib/thnuclnt/bin/$file-$v$x
		cat > $lib/thnuclnt/bin/$file-$PPID <<EOF
#! /bin/bash
case "\$#" in
    0)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/$file-$v$x -0 "\$0"
        ;;
    1)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/$file-$v$x -0 "\$0" "\$1"
        ;;
    2)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/$file-$v$x -0 "\$0" "\$1" "\$2"
        ;;
    3)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/$file-$v$x -0 "\$0" "\$1" "\$2" "\$3"
        ;;
    4)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/$file-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4"
        ;;
    5)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/$file-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5"
        ;;
    6)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/$file-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6"
        ;;
    7)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/$file-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6" "\$7"
        ;;
    8)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/$file-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6" "\$7" "\$8"
        ;;
    9)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/$file-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6" "\$7" "\$8" "\$9"
        ;;
    *)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/$file-$v$x -0 "\$0" \$@
        ;;
esac
EOF
		chmod 755 $lib/thnuclnt/bin/$file-$PPID
		mv -f $lib/thnuclnt/bin/$file-$PPID $lib/thnuclnt/bin/$file-$v
	    fi
	    ;;
	thnuclnt-ldstatic)
	    cp $arch/$image $lib/thnuclnt/bin/$file-$v
	    chmod 755 $lib/thnuclnt/bin/$file-$v
	    ;;
	thnucups)
	    # we install thnucups separately,
	    # thus we can set separate, regular execute permissions for the filter -
	    # thnuclnt binary gets installed with s-bit set. some CUPS implementations
	    # complain about insecure permissions, if the s-bit of a filter is set.
	    if [ "$image" = "$file" ]; then
		cp $arch/$image $lib/thnuclnt/bin/$file-$v$x
		chmod 755 $lib/thnuclnt/bin/$file-$v$x
	    else
		ln -f $lib/thnuclnt/bin/thnuclnt-$xv $lib/thnuclnt/bin/$file-$v
	    fi
	    ;;
	*)
	    ln -sf thnuclnt-$xv $lib/thnuclnt/bin/$file-$v
	    ;;
    esac
    if [ ! -d $instd ]; then
	continue
    fi
    r=`relpath $lib/thnuclnt/bin $instd`
    case "$file" in
	thnucups)
            case "$sys" in
		Linux|Darwin)
                    # at least for ubuntu CUPS is jailed by apparmor
                    # and symlinks (to directories not enabled via
                    # apparmor) won't function.
                    # thus we try linking filters the hard way first,
                    # at least for those systems where (running) binary
                    # replacement is possible.
		    #
		    # 07/02/13 new strategy:
		    # we always install a copy to CUPS filter directory now,
		    # either as hard link or as true copy, as we want to keep
		    # that global reference installed when uninstalling.
                    if ! ln -f $lib/thnuclnt/bin/$file-$v $instd/$file-$PPID; then
			# ln -sf $r/$file-$v $instd/$file-$PPID
			cp $lib/thnuclnt/bin/$file-$v $instd/$file-$PPID
                    fi
                    ;;
		*)
                    ln -sf $r/$file-$v $instd/$file-$PPID
                    ;;
            esac
            mv -f $instd/$file-$PPID $instd/$file
            if [ -f /etc/redhat-release ] && [ ! "$restorecon" = "" ]; then
		restorecon $instd/$file
            fi
	    ;;
	*)
            ln -sf $r/$file-$v $instd/$file-$PPID
            mv -f $instd/$file-$PPID $instd/$file
	    ;;
    esac
done


case "$sys" in
    Linux)
        if [ -f $initd/thnuclnt ]; then
            if $initd/thnuclnt status; then
                $initd/thnuclnt stop
                svc=1;
            fi
        fi
        v=`cat init.d/linux/thnuclnt | grep "$""Revision: " | sed -e "s/""\$""Revision: //" | cut "-d$" -f2`
        echo $lib/thnuclnt/init.d/thnuclnt-$v >> $lib/thnuclnt/Manifest-$PPID
        echo $initd/thnuclnt >> $lib/thnuclnt/Manifest-$PPID
        if [ ! -f $lib/thnuclnt/init.d/thnuclnt-$v ]; then
            if [ -L $initd/thnuclnt ]; then
                oldv=`cat $initd/thnuclnt | grep "$""Revision: " | sed -e "s/""\$""Revision: //" | cut "-d$" -f2`
                [ "$vshift" = "0" ] || echo $lib/thnuclnt/init.d/thnuclnt-$oldv >> $lib/thnuclnt/Manifest-$PPID
            fi
            cp init.d/linux/thnuclnt $lib/thnuclnt/init.d/thnuclnt-$v
            chmod 555 $lib/thnuclnt/init.d/thnuclnt-$v
            if [ ! -f $initd/thnuclnt ] || [ -L $initd/thnuclnt ]; then
                ln -sf $initdlib/thnuclnt/init.d/thnuclnt-$v $initd/thnuclnt-$PPID
                mv -f $initd/thnuclnt-$PPID $initd/thnuclnt
            fi
        fi
        ;;
    Darwin)
        if [ -f $initd/thnuclnt.plist ]; then
            if [ "`launchctl list | grep thnuclnt`" = "com.thinprint.thnuclnt" ]; then
                service thnuclnt stop
                svc=1;
            fi
        fi
        v=`cat init.d/darwin/thnuclnt.plist | grep "$""Revision: " | sed -e "s/""\$""Revision: //" | cut "-d$" -f2`
        echo $lib/thnuclnt/init.d/thnuclnt.plist-$v >> $lib/thnuclnt/Manifest-$PPID
        echo $initd/thnuclnt.plist >> $lib/thnuclnt/Manifest-$PPID
        if [ ! -f $lib/thnuclnt/init.d/thnuclnt.plist-$v ]; then
            if [ -L $initd/thnuclnt.plist ]; then
                oldv=`cat $initd/thnuclnt.plist | grep "$""Revision: " | sed -e "s/""\$""Revision: //" | cut "-d$" -f2`
                [ "$vshift" = "0" ] || echo $lib/thnuclnt/init.d/thnuclnt.plist-$oldv >> $lib/thnuclnt/Manifest-$PPID
            fi
            cp init.d/darwin/thnuclnt.plist $lib/thnuclnt/init.d/thnuclnt.plist-$v
            chmod 444 $lib/thnuclnt/init.d/thnuclnt.plist-$v
            if [ ! -f $initd/thnuclnt.plist ] || [ -L $initd/thnuclnt.plist ]; then
                ln -sf $initdlib/thnuclnt/init.d/thnuclnt.plist-$v $initd/thnuclnt.plist-$PPID
                mv -f $initd/thnuclnt.plist-$PPID $initd/thnuclnt.plist
            fi
        fi
        ;;
    *)
        echo target $mach-$sys not supported
        exit 1
        ;;
esac

v=`$appld $arch/thnuclntd$x -v | sed -e "s/Version /,/" | cut -d, -f2`
echo $lib/thnuclnt/bin/thnuclntd-$v >> $lib/thnuclnt/Manifest-$PPID
if [ ! "$x" = "" ]; then
    echo $lib/thnuclnt/bin/thnuclntd-$v$x >> $lib/thnuclnt/Manifest-$PPID
fi
echo $sbin/thnuclntd >> $lib/thnuclnt/Manifest-$PPID
if [ ! -f $lib/thnuclnt/bin/thnuclntd-$v ] || [ ! -f $lib/thnuclnt/bin/thnuclntd-$v$x ]; then
    if [ -L $sbin/thnuclntd ]; then
        oldv=`$sbin/thnuclntd -v | sed -e "s/Version /,/" | cut -d, -f2`
        [ "$vshift" = "0" ] || echo $lib/thnuclnt/bin/thnuclntd-$oldv >> $lib/thnuclnt/Manifest-$PPID
    fi
    cp $arch/thnuclntd$x $lib/thnuclnt/bin/thnuclntd-$v$x
    chmod 755 $lib/thnuclnt/bin/thnuclntd-$v$x
    if [ ! "$x" = "" ]; then
	cat > $lib/thnuclnt/bin/thnuclntd-$PPID <<EOF
#! /bin/bash
case "\$#" in
    0)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/thnuclntd-$v$x -0 "\$0"
        ;;
    1)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/thnuclntd-$v$x -0 "\$0" "\$1"
        ;;
    2)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/thnuclntd-$v$x -0 "\$0" "\$1" "\$2"
        ;;
    3)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/thnuclntd-$v$x -0 "\$0" "\$1" "\$2" "\$3"
        ;;
    4)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/thnuclntd-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4"
        ;;
    5)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/thnuclntd-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5"
        ;;
    6)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/thnuclntd-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6"
        ;;
    7)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/thnuclntd-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6" "\$7"
        ;;
    8)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/thnuclntd-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6" "\$7" "\$8"
        ;;
    9)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/thnuclntd-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6" "\$7" "\$8" "\$9"
        ;;
    *)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/thnuclntd-$v$x -0 "\$0" \$@
        ;;
esac
EOF
	chmod 755 $lib/thnuclnt/bin/thnuclntd-$PPID
	mv -f $lib/thnuclnt/bin/thnuclntd-$PPID $lib/thnuclnt/bin/thnuclntd-$v
    fi
    ln -sf $sbinlib/thnuclnt/bin/thnuclntd-$v $sbin/thnuclntd-$PPID
    mv -f $sbin/thnuclntd-$PPID $sbin/thnuclntd
fi

case "$sys" in
    Linux)
        if [ ! "$vcups" = "0" ]; then
            if [ "false" = "" ]; then
		if [ -f $initd/cupsys ]; then
                    cupsys=$initd/cupsys
		fi
		if [ -f $initd/cups ]; then
                    cupsys=$initd/cups
		fi
		if [ -f $cupsys ]; then
                    if $cupsys status; then
			$cupsys restart
                    fi
		else
                    echo failed to detect CUPS service script. you have to restart CUPS service manually. >&2
		fi
	    else
		svcreload cupsd
	    fi
        fi
        if [ "$svc" = "1" ]; then
            $initd/thnuclnt start
        fi
        ;;
    Darwin)
        if [ "false" = "" ]; then
            if [ -d /Applications ] && [ ! -d /Applications/thnuconf.app ] && [ ! "$osacompile" = "" ]; then
                osacompile -e 'do shell script "mkdir -p ~/.thnuclnt && EDITOR=/Applications/TextEdit.app/Contents/MacOS/TextEdit thnuconf"' -x -o /Applications/thnuconf.app
            fi
            if [ -d /Applications ] && [ ! -d /Applications/thnuclnt.app ] && [ ! "$osacompile" = "" ]; then
                osacompile -e 'tell application "Terminal"' -e 'activate' -e 'do script with command "thnuclnt -fg;exit"' -e 'end tell' -x -o /Applications/thnuclnt.app
            fi
        fi
        if [ ! "$vcups" = "0" ]; then
            if [ "false" = "" ]; then
		# ATT: works for old Darwin os, but not for current!
		SystemStarter restart PrintingServices
	    else
		svcreload cupsd
	    fi
	fi
        if [ "$svc" = "1" ]; then
            service thnuclnt start
        fi
        ;;
    *)
        echo target $mach-$sys not supported
        exit 1
        ;;
esac


v=`$appld $arch/.thnumod$x -v | sed -e "s/Version /,/" | cut -d, -f2`
echo $lib/thnuclnt/bin/.thnumod-$v >> $lib/thnuclnt/Manifest-$PPID
if [ ! "$x" = "" ]; then
    echo $lib/thnuclnt/bin/.thnumod-$v$x >> $lib/thnuclnt/Manifest-$PPID
fi
echo $etc/thnuclnt/.thnumod >> $lib/thnuclnt/Manifest-$PPID
if [ ! -f $lib/thnuclnt/bin/.thnumod-$v ] || [ ! -f $lib/thnuclnt/bin/.thnumod-$v$x ]; then
    cp $arch/.thnumod$x $lib/thnuclnt/bin/.thnumod-$v$x
    chmod 755 $lib/thnuclnt/bin/.thnumod-$v$x
    if [ ! "$x" = "" ]; then
	cat > $lib/thnuclnt/bin/.thnumod-$PPID <<EOF
#! /bin/bash
case "\$#" in
    0)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/.thnumod-$v$x -0 "\$0"
        ;;
    1)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/.thnumod-$v$x -0 "\$0" "\$1"
        ;;
    2)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/.thnumod-$v$x -0 "\$0" "\$1" "\$2"
        ;;
    3)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/.thnumod-$v$x -0 "\$0" "\$1" "\$2" "\$3"
        ;;
    4)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/.thnumod-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4"
        ;;
    5)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/.thnumod-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5"
        ;;
    6)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/.thnumod-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6"
        ;;
    7)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/.thnumod-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6" "\$7"
        ;;
    8)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/.thnumod-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6" "\$7" "\$8"
        ;;
    9)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/.thnumod-$v$x -0 "\$0" "\$1" "\$2" "\$3" "\$4" "\$5" "\$6" "\$7" "\$8" "\$9"
        ;;
    *)
        exec $lib/thnuclnt/bin/`basename $appld` $lib/thnuclnt/bin/.thnumod-$v$x -0 "\$0" \$@
        ;;
esac
EOF
	chmod 755 $lib/thnuclnt/bin/.thnumod-$PPID
	mv -f $lib/thnuclnt/bin/.thnumod-$PPID $lib/thnuclnt/bin/.thnumod-$v
    fi
fi
case "$sys" in
    Linux|Darwin)
        # now we prefer hardlinking for all those systems
        # where (running) binary replacement is possible,
        # as special adjustments for particular systems
        # may need to be applied for .thnumod
        # (lowering jail security settings for example).
        # these ajustments ought preferably refer
        # to a fixed .thnumod reference
        if ! ln -f $lib/thnuclnt/bin/.thnumod-$v $etc/thnuclnt/.thnumod-$PPID; then
            ln -sf ../$etclib/thnuclnt/bin/.thnumod-$v $etc/thnuclnt/.thnumod-$PPID
        fi
        ;;
    *)
        ln -sf ../$etclib/thnuclnt/bin/.thnumod-$v $etc/thnuclnt/.thnumod-$PPID
        ;;
esac
mv -f $etc/thnuclnt/.thnumod-$PPID $etc/thnuclnt/.thnumod


cp rev.rc $lib/thnuclnt/rev.rc-$PPID
mv -f $lib/thnuclnt/rev.rc-$PPID $lib/thnuclnt/rev.rc
echo $lib/thnuclnt/rev.rc >> $lib/thnuclnt/Manifest-$PPID
mv -f $lib/thnuclnt/Manifest-$PPID $lib/thnuclnt/Manifest


for file in `find $lib/thnuclnt`; do
    if [ -f $file ] || [ -L $file ]; then
        if [ "`cat $lib/thnuclnt/Manifest | grep $file`" = "" ]; then
            rm -f $file
        fi
    fi
done


echo done.
