"""
Copyright 2007 VMware, Inc.  All rights reserved. -- VMware Confidential

@todo: We should log more informative messages (like line number,
etc.) for errors and above.
"""

import os
import pwd
import logging

from logging.handlers import RotatingFileHandler

import vmis

envLevel = os.environ.get('VMIS_LOG_LEVEL') or getattr(vmis, 'LOG_LEVEL', 'INFO')

#Set level as INFO by default
level = 20

try:
   level={'NOTSET'  : 0,
          'DEBUG'   : 10,
          'INFO'    : 20,
          'WARNING' : 30,
          'ERROR'   : 40,
          'CRITICAL': 50
         }[envLevel]
except KeyError:
   # If the environ setting is not right, set it by default
   level = 20

username = pwd.getpwuid(os.getuid())[0]
dirname = '/tmp/vmware-%s' % username
LOG_FILE = '%s/vmware-installer-%s.log' % (dirname, os.getpid())
   # Make sure this directory exists.  Assuming /tmp exists.
try:
   os.mkdir(dirname)
except OSError:
   # It's okay if it already exists
   pass

if level <= logging.DEBUG:
   MAX_BYTES = 0
   BACKUP_COUNT = 0
else:
   MAX_BYTES = 2 ** 20 # 1 MB
   BACKUP_COUNT=1

def setLevel(level):
   """
   Set the global log level.

   @param level: one of the log levels from L{logging}
   """
   fileLogger.setLevel(level)

def getLog(name):
   """
   Returns the logger with the given name.

   @param name: dot-separated name of the logger
   """
   return logging.getLogger(name)

def Shutdown():
   """ Shutdown logging """
   logging.shutdown()

getLog(None).setLevel(level)

# Set the file mode as "w" since the pid may be the same
fileLogger = RotatingFileHandler(LOG_FILE, mode='w', maxBytes=MAX_BYTES, backupCount=BACKUP_COUNT)
#fileLogger.setFormatter(logging.Formatter('%(name)s %(module)s.%(funcName)s %(lineno)d %(message)s'))
fileLogger.setFormatter(logging.Formatter(u'[%(asctime)s] %(message)s'))
getLog(None).addHandler(fileLogger)
