"""
Copyright 2008-2015 VMware, Inc.  All rights reserved. -- VMware Confidential

A null UI useful for doing automated installs whose output is
captured.

@todo: Refactor this to share the skeleton code with console.
"""

import sys

from vmis.core.errors import EULAError
from vmis.ui import console
from vmis.ui.uiAppControl import UIAppControl
from vmis.util import Format

class Wizard(console.Wizard):
   """ Non-interactive UI wizard """
   def __init__(self, txn):
      # This initializier was originally overridden so that the curses
      # setup doesn't get called.
      # Now also set up App Control.
      try:
         self.appControl = UIAppControl()
      except:
         self.appControl = None

   def ShowFinish(self, success, message):
      """ Prints finish message """
      if success:
         print Format(message)
      else:
         print >> sys.stderr, Format(message)

   def UserMessage(self, messageType, message, useWrapper=False):
      """ In null console, a passthrough to ShowMessage """
      ShowMessage(messageType, message, useWrapper=useWrapper)

   def ShowPromptInstall(self, installComponents):
      pass

   def SetProgress(self, fraction):
      """ Print a progress bar at the given fraction """
      pass

   def ShowProgress(self):
      pass

   def SetPrimaryProgressMessage(self, text):
      print text

   def SetSecondaryProgressMessage(self, text):
      print text

EULA = console.EULA
Question = console.Question
MultiChoiceQuestion = console.Question
Finish = console.Finish
PromptInstall = console.PromptInstall
ShowMessage = console.ShowMessage
