"""
Copyright 2014-2015 VMware, Inc.  All rights reserved. -- VMware Confidential

Dummy vmware-horizon-virtual-printing component.
"""

import os

DEST = LIBDIR/'vmware/view/virtualPrinting'

class VMwareHorizonTP(Installer):
   def InitializeQuestions(self, old, new, upgrade):
      defaultTP = self.GetAnswer('tpEnable')
      if defaultTP:
         qlevel = 'CUSTOM'
      else:
         qlevel = 'REGULAR'

      self.AddMultiChoiceQuestion('YesNo',
                                  key='tpEnable',
                                  text='Virtual Printing',
                                  required=True,
                                  default='yes',
                                  footer='The Virtual Printing component allows you to use local or network printers from a remote desktop without requiring that additional print drivers be installed in the remote desktop.',
                                  level=qlevel)

   def InitializeInstall(self, old, new, upgrade):
      tpEnable = self.GetAnswer('tpEnable')
      if tpEnable == 'yes':
         self.AddTarget('File', 'bin/*', DEST)
         self.AddTarget('File', 'scripts/*', DEST/'scripts')
         self.AddTarget('File', 'lib/*', '/usr/lib/vmware/rdpvcbridge/')
         self.SetPermission('/usr/lib/vmware/rdpvcbridge/*', BINARY)
         self.SetPermission(DEST/'*', BINARY)
      if (CONFDIR/'abortInstall').exists():
         raise InstallError('View abort install')

   def InitializeUninstall(self, old, new, upgrade):
      if (CONFDIR/'abortUninstall').exists():
         raise InstallError('View aborting uninstall')
      self.RunCommand('true', ignoreErrors=True)

   def PreUninstall(self, old, new, upgrade):
      tpEnable = self.GetAnswer('tpEnable')
      if tpEnable == 'yes':
         if os.environ['INSTALL_ARCH'] == "x86":
            os.environ['arch'] = 'i586-linux-NOSSL'
         else:
            os.environ['arch'] = 'x86_64-linux-NOSSL'
         self.RunCommand('/bin/bash', DEST/'uninstall.sh', ignoreErrors=True)

   def PostInstall(self, old, new, upgrade):
      tpEnable = self.GetAnswer('tpEnable')
      if tpEnable == 'yes':
         self.RunCommand('chmod', 'a+x', '-R', DEST, ignoreErrors=True)
         if os.environ['INSTALL_ARCH'] == "x86":
            os.environ['arch'] = 'i586-linux-vmAppLd'
         else:
            os.environ['arch'] = 'x86_64-linux-vmAppLd'
         self.RunCommand('/bin/bash', DEST/'setup.sh', ignoreErrors=True)
         self.AddScanFile(LIBDIR/'vmware/rdpvcbridge/tprdp.so')
      self.SetConfig('tpComponent', 'test')

   def PostUninstall(self, old, new, upgrade):
      self.DelConfig('tpComponent')

   def PreExit(self, old, new, upgrade):
      tpEnable = self.GetAnswer('tpEnable')
      if tpEnable == 'yes':
         self.RunCommand('rm', '/usr/lib/vmware/view/virtualPrinting/scripts', "-rf", ignoreErrors=True)
