"""
Copyright 2014 VMware, Inc.  All rights reserved. -- VMware Confidential

Dummy vmware-horizon-tsdr component.
"""

class VMwareHorizonFolderRedirection(Installer):
   def InitializeQuestions(self, old, new, upgrade):
      defaultFolderRedirection = self.GetAnswer('tsdrEnable')
      if defaultFolderRedirection:
         qlevel = 'CUSTOM'
      else:
         qlevel = 'REGULAR'

      self.AddMultiChoiceQuestion('YesNo',
                                  key='tsdrEnable',
                                  text='Client Drive Redirection',
                                  required=True,
                                  default='yes',
                                  footer='The Client Drive Redirection component enables folder redirection from your local computer to the remote desktop.',
                                  level=qlevel)

   def InitializeInstall(self, old, new, upgrade):
      tsdrEnable = self.GetAnswer('tsdrEnable')
      if tsdrEnable == 'yes':
          self.AddTarget('File', 'lib/*', LIBDIR)
          self.SetPermission(LIBDIR/'vmware/view/vdpService/libtsdrClient.so', BINARY)

      if (CONFDIR/'abortInstall').exists():
         raise InstallError('View abort install')

   def InitializeUninstall(self, old, new, upgrade):
      if (CONFDIR/'abortUninstall').exists():
         raise InstallError('View aborting uninstall')
      self.RunCommand('true', ignoreErrors=True)

   def PostInstall(self, old, new, upgrade):
      self.SetConfig('tsdrComponent', 'test')
      tsdrEnable = self.GetAnswer('tsdrEnable')
      if tsdrEnable == 'yes':
         self.AddScanFile(LIBDIR/'vmware/view/vdpService/libtsdrClient.so')

   def PostUninstall(self, old, new, upgrade):
      self.DelConfig('tsdrComponent')
      self.DelConfig('tsdrComponent')
