"""
Copyright 2014 VMware, Inc.  All rights reserved. -- VMware Confidential

Dummy vmware-horizon-smartcard component.
"""

class VMwareHorizonSmartCard(Installer):
   def InitializeQuestions(self, old, new, upgrade):
      defaultSmartcard = self.GetAnswer('smartcardEnable')
      if defaultSmartcard:
         qlevel = 'CUSTOM'
      else:
         qlevel = 'REGULAR'

      self.AddMultiChoiceQuestion('YesNo',
                                  key='smartcardEnable',
                                  text='Smart Card',
                                  required=True,
                                  default='yes',
                                  footer='The Smart Card component enables Smart Card device redirection from your local computer to the remote desktop.',
                                  level=qlevel)

   def InitializeInstall(self, old, new, upgrade):
      smartcardEnable = self.GetAnswer('smartcardEnable')
      if smartcardEnable == 'yes':
          self.AddTarget('File', 'lib/*', LIBDIR)
          self.SetPermission(LIBDIR/'pcoip/vchan_plugins/libscredirvchanclient.so', BINARY)

      if (CONFDIR/'abortInstall').exists():
         raise InstallError('View abort install')

   def InitializeUninstall(self, old, new, upgrade):
      if (CONFDIR/'abortUninstall').exists():
         raise InstallError('View aborting uninstall')
      self.RunCommand('true', ignoreErrors=True)

   def PostInstall(self, old, new, upgrade):
      self.SetConfig('smartcardComponent', 'test')
      defaultSmartcard = self.GetAnswer('smartcardEnable')
      if defaultSmartcard == 'yes':
         self.AddScanFile(LIBDIR/'pcoip/vchan_plugins/libscredirvchanclient.so')

   def PostUninstall(self, old, new, upgrade):
      self.DelConfig('smartcardComponent')
      self.DelConfig('smartcardComponent')
