"""
Copyright 2014-2015 VMware, Inc.  All rights reserved. -- VMware Confidential

Dummy vmware-horizon-rtav component.
"""

class VMwareHorizonRTAV(Installer):
   def InitializeQuestions(self, old, new, upgrade):
      defaultRTAV = self.GetAnswer('rtavEnable')
      if defaultRTAV:
         qlevel = 'CUSTOM'
      else:
         qlevel = 'REGULAR'

      self.AddMultiChoiceQuestion('YesNo',
                                  key='rtavEnable',
                                  text='Real-Time Audio-Video',
                                  required=True,
                                  default='yes',
                                  footer='The Real-Time Audio-Video component allows you to use local computer\'s webcam or microphone on the remote desktop.',
                                  level=qlevel)

   def InitializeInstall(self, old, new, upgrade):
      rtavEnable = self.GetAnswer('rtavEnable')
      if rtavEnable == 'yes':
          self.AddTarget('File', 'lib/*', LIBDIR)
          self.SetPermission(LIBDIR/'pcoip/vchan_plugins/libviewMMDevRedir.so', BINARY)

      if (CONFDIR/'abortInstall').exists():
         raise InstallError('View abort install')

   def InitializeUninstall(self, old, new, upgrade):
      if (CONFDIR/'abortUninstall').exists():
         raise InstallError('View aborting uninstall')
      self.RunCommand('true', ignoreErrors=True)

   def PostInstall(self, old, new, upgrade):
      self.SetConfig('rtavComponent', 'test')
      defaultRTAV = self.GetAnswer('rtavEnable')
      if defaultRTAV == 'yes':
         self.AddScanFile(LIBDIR/'pcoip/vchan_plugins/libviewMMDevRedir.so')

   def PostUninstall(self, old, new, upgrade):
      self.DelConfig('rtavComponent')
      self.DelConfig('rtavComponent')
