"""
Copyright 2014 VMware, Inc.  All rights reserved. -- VMware Confidential

Dummy vmware-horizon-pcoip component.
"""

class VMwareHorizonPCoIP(Installer):
   def InitializeInstall(self, old, new, upgrade):
      self.AddTarget('File', 'pcoip/lib/*', LIBDIR)
      self.AddTarget('File', 'pcoip/bin/*', BINDIR)
      self.SetPermission(LIBDIR/'pcoip/vchan_plugins/*', BINARY)
      self.SetPermission(LIBDIR/'vmware/*', BINARY)
      self.SetPermission(LIBDIR/'vmware/view/vdpService/*', BINARY)
      self.AddTarget('HardLink',
                     LIBDIR/'pcoip/vchan_plugins/libmksvchanclient.so',
                     LIBDIR/'vmware/view/vdpService/libmksvchanclient.so')
      self.AddTarget('Link',
                     LIBDIR/'vmware/libssl.so.1.0.2',
                     LIBDIR/'vmware/libssl.so.1.0.1')
      self.AddTarget('Link',
                     LIBDIR/'vmware/libcrypto.so.1.0.2',
                     LIBDIR/'vmware/libcrypto.so.1.0.1')

      if (CONFDIR/'abortInstall').exists():
         raise InstallError('View abort install')

   def InitializeUninstall(self, old, new, upgrade):
      if (CONFDIR/'abortUninstall').exists():
         raise InstallError('View aborting uninstall')
      self.RunCommand('true', ignoreErrors=True)

   def PostInstall(self, old, new, upgrade):
      self.SetConfig('pcoipComponent', 'test')
      self.AddScanFile(BINDIR/'vmware-remotemks')
      self.AddScanFile(BINDIR/'vmware-remotemks-container')
      self.AddScanFile(BINDIR/'vmware-flash-projector')
      self.AddScanFile(LIBDIR/'libpcoip_client.so')
      self.AddScanFile(LIBDIR/'vmware/view/vdpService/librdeSvc.so')
      self.AddScanFile(LIBDIR/'vmware/view/vdpService/libviewMPClient.so')
      self.AddScanFile(LIBDIR/'vmware/libudpProxyLib.so')
      self.AddScanFile(LIBDIR/'pcoip/vchan_plugins/libmksvchanclient.so')
      self.AddScanFile(LIBDIR/'pcoip/vchan_plugins/librdpvcbridge.so')
      self.AddScanFile(LIBDIR/'pcoip/vchan_plugins/libvdpservice.so')

   def PostUninstall(self, old, new, upgrade):
      self.DelConfig('pcoipComponent')
      self.DelConfig('pcoipComponent')
