"""
Copyright 2016 VMware, Inc.  All rights reserved. -- VMware Confidential

Dummy vmware-horizon-tsdr component.
"""
class VMwareHorizonMultiMediaRedirection(Installer):
   def InitializeQuestions(self, old, new, upgrade):
      defaultMultiMediaRedirection = self.GetAnswer('mmrEnable')
      if defaultMultiMediaRedirection:
         qlevel = 'CUSTOM'
      else:
         qlevel = 'REGULAR'

      self.AddMultiChoiceQuestion('YesNo',
                                  key='mmrEnable',
                                  text='Multimedia Redirection (MMR)',
                                  required=True,
                                  default='yes',
                                  footer='With multimedia redirection (MMR), the multimedia stream is processed on the client system.',
                                  level=qlevel)

   def InitializeInstall(self, old, new, upgrade):
      mmrEnable = self.GetAnswer('mmrEnable')
      if mmrEnable == 'yes':
         self.AddTarget('File', 'config/*', '/etc/vmware/vdp/host_overlay_plugins/')
         self.AddTarget('File', 'lib/*', LIBDIR)
         self.SetPermission(LIBDIR/'vmware/view/vdpService/libtsmmrClient.so', BINARY)

      if (CONFDIR/'abortInstall').exists():
         raise InstallError('View abort install')

   def InitializeUninstall(self, old, new, upgrade):
      if (CONFDIR/'abortUninstall').exists():
         raise InstallError('View aborting uninstall')
      self.RunCommand('true', ignoreErrors=True)

   def PostInstall(self, old, new, upgrade):
      self.SetConfig('mmrComponent', 'test')
      mmrEnable = self.GetAnswer('mmrEnable')
      if mmrEnable == 'yes':
         self.AddScanFile(LIBDIR/'vmware/view/vdpService/libtsmmrClient.so')

   def PostUninstall(self, old, new, upgrade):
      self.DelConfig('mmrComponent')
      self.DelConfig('mmrComponent')
