"""
Copyright 2014 VMware, Inc.  All rights reserved. -- VMware Confidential

Dummy client component.
"""

class VMwareHorizonClient(Installer):
   def PreTransactionInstall(self, old, new, upgrade):
      iconImages = ['extras/artwork/linux_view_%dx.png' % size for size in [16, 32, 48, 82, 128]]
      gui.SetHeaderImage('extras/artwork/linux_view_82x.png')
      gui.SetIconImages(iconImages)
      gui.SetBannerImage('extras/artwork/linux-installer-card.png')

   def InitializeInstall(self, old, new, upgrade):
      self.AddTarget('File', 'bin/vmware-view-log-collector', BINDIR/'vmware-view-log-collector')
      self.AddTarget('File', 'lib/vmware/view/bin/vmware-view', '/usr/lib/vmware/view/bin/vmware-view')
      self.AddTarget('File', 'bin/vmware-view', BINDIR/'vmware-view')
      self.AddTarget('File', 'share/*', '/usr/share/')
      self.AddTarget('File', 'doc/*', '/usr/share/doc/vmware-horizon-client/')
      self.AddTarget('File', 'patches/*', '/usr/share/doc/vmware-horizon-client/patches/')
      self.AddTarget('File', 'debug/*', '/usr/share/doc/vmware-horizon-client/debug/')
      self.SetPermission(BINDIR/'vmware-view', 0o755)
      self.SetPermission('/usr/lib/vmware/view/bin/vmware-view', BINARY)
      self.SetPermission(BINDIR/'vmware-view-log-collector', BINARY)

      if (CONFDIR/'abortInstall').exists():
         raise InstallError('View abort install')

   def InitializeUninstall(self, old, new, upgrade):
      if (CONFDIR/'abortUninstall').exists():
         raise InstallError('View aborting uninstall')
      self.RunCommand('true', ignoreErrors=True)

   def PostInstall(self, old, new, upgrade):
      self.SetConfig('viewComponent', 'test')
      self.AddScanFile(LIBDIR/'vmware/view/bin/vmware-view')
      self.RunCommand('ldconfig')

   def PostUninstall(self, old, new, upgrade):
      self.DelConfig('viewComponent')
      self.DelConfig('viewComponent')
