!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_twosubc2onesubc
  use cubetools_structure
  use cubetemplate_two2one_template
  use cubetemplate_sperange_types
  use cubetemplate_twosubc2onesubc_template
  use cubetemplate_messaging
  !
  public :: twosubc2onesubc
  public :: cubetemplate_twosubc2onesubc_command
  private
  !
  type, extends(twosubc2onesubc_comm_t) :: ext_twosubc2onesubc_comm_t
     type(option_t), pointer :: factor
     type(sperange_opt_t)    :: range
   contains
     procedure, public :: register => cubetemplate_ext_twosubc2onesubc_register
     procedure, public :: parse    => cubetemplate_ext_twosubc2onesubc_parse
  end type ext_twosubc2onesubc_comm_t
  type(ext_twosubc2onesubc_comm_t) :: twosubc2onesubc
  !
  type, extends(twosubc2onesubc_user_t) :: ext_twosubc2onesubc_user_t
     type(sperange_user_t) :: range
     character(len=argu_l) :: factor
   contains
     procedure, public :: toprog => cubetemplate_ext_twosubc2onesubc_user_toprog
  end type ext_twosubc2onesubc_user_t
  !
  type, extends(twosubc2onesubc_prog_t) :: ext_twosubc2onesubc_prog_t
     type(sperange_prog_t) :: range
     real(kind=sign_k)     :: factor
   contains
     procedure, private :: act => cubetemplate_ext_twosubc2onesubc_prog_act
  end type ext_twosubc2onesubc_prog_t
  !
contains
  !
  subroutine cubetemplate_twosubc2onesubc_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(ext_twosubc2onesubc_user_t) :: user
    type(ext_twosubc2onesubc_prog_t) :: prog
    character(len=*), parameter :: rname='TWOSUBC2ONESUBC>COMMAND'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call twosubc2onesubc%command(line,user,prog,error)
    if (error) return
  end subroutine cubetemplate_twosubc2onesubc_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_ext_twosubc2onesubc_register(comm,error)
    use cubedag_allflags
    use cubeadm_cubeid_types
    use cubeadm_cubeprod_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(ext_twosubc2onesubc_comm_t), intent(inout) :: comm
    logical,                           intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(standard_arg_t) :: stdarg
    type(cube_prod_t) :: cubeprod
    character(len=*), parameter :: comm_abstract = 'Template command to access input/output data per subcubes'
    character(len=*), parameter :: comm_help = 'Input and output cubes are real'
    character(len=*), parameter :: rname='TWOSUBC2ONESUBC>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'TWOSUBC2ONESUBC','[cube1] [cube2]',&
         comm_abstract,&
         comm_help,&
         cubetemplate_twosubc2onesubc_command,&
         comm%comm,error)
    if (error) return
    call cubearg%register(&
         'FIRST',&
         'First cube',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         code_read,&
         code_access_subset,&
         comm%incube1,&
         error)
    if (error) return
    call cubearg%register(&
         'SECOND',&
         'Second cube',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         code_read,&
         code_access_subset,&
         comm%incube2,&
         error)
    if (error) return
    !
    call comm%range%register(&
         'RANGE',&
         'Define velocity range(s)',&
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'FACTOR','factor',&
         'Compute CUBE1*factor+CUBE2',&
         strg_id,&
         comm%factor,error)
    if (error) return
    call stdarg%register(&
         'factor',&
         'factor',&
         'Default factor is 1',&
         code_arg_mandatory, error)
    if (error) return
    !
    ! Products
    call cubeprod%register(  &
         'OUTPUT',  &
         'The result of the command',  &
         strg_id,  &
         [flag_template],  &
         comm%oucube,  &
         error)
    if (error)  return
  end subroutine cubetemplate_ext_twosubc2onesubc_register
  !
  subroutine cubetemplate_ext_twosubc2onesubc_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! TWOSUBC2ONESUBC [cubname1] [cubname2]
    ! /RANGE vfirst vlast
    ! /FACTOR factor
    !----------------------------------------------------------------------
    class(ext_twosubc2onesubc_comm_t), intent(in)    :: comm
    character(len=*),                  intent(in)    :: line
    class(two2one_user_t),             intent(out)   :: user
    logical,                           intent(inout) :: error
    !
    type(ext_twosubc2onesubc_user_t), pointer :: iuser
    character(len=*), parameter :: rname='EXT>TWOSUBC2ONESUBC>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    iuser => ext_twosubc2onesubc_user_ptr(user,error)
    if (error)  return
    call comm%two2one_comm_t%parse(line,iuser,error)
    if (error) return
    call comm%range%parse(line,iuser%range,error)
    if (error) return
    call cubetemplate_ext_twosubc2onesubc_parse_factor(line,comm%factor,iuser%factor,error)
    if (error) return
  end subroutine cubetemplate_ext_twosubc2onesubc_parse
  !
  subroutine cubetemplate_ext_twosubc2onesubc_parse_factor(line,opt,user,error)
    !----------------------------------------------------------------------
    ! /FACTOR factor
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    type(option_t),   intent(in)    :: opt
    character(len=*), intent(out)   :: user
    logical,          intent(inout) :: error
    !
    logical :: present
    integer(kind=4), parameter :: iarg=1
    character(len=*), parameter :: rname='TWOSUBC2ONESUBC>PARSE>FACTOR'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call opt%present(line,present,error)
    if (error) return
    if (present) then
       call cubetools_getarg(line,opt,iarg,user,mandatory,error)
       if (error) return
    else
       user = strg_star
    endif
  end subroutine cubetemplate_ext_twosubc2onesubc_parse_factor
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_ext_twosubc2onesubc_user_toprog(user,comm,prog,error)
    use cubetools_user2prog
    use cubetools_unit
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(ext_twosubc2onesubc_user_t), intent(in)    :: user
    class(two2one_comm_t),             intent(in)    :: comm
    class(two2one_prog_t),             intent(inout) :: prog
    logical,                           intent(inout) :: error
    !
    type(unit_user_t) :: nounit
    real(kind=sign_k), parameter :: default=1.0
    type(ext_twosubc2onesubc_prog_t), pointer :: iprog
    character(len=*), parameter :: rname='TWOSUBC2ONESUBC>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call user%two2one_user_t%toprog(comm,prog,error)
    if (error) return
    !
    iprog => ext_twosubc2onesubc_prog_ptr(prog,error)
    if (error)  return
    call user%range%toprog(iprog%incube1,iprog%range,error)
    if (error) return
    call cubetools_unit_get(strg_star,unit_unk%id,nounit,error)
    if (error) return
    call cubetools_user2prog_resolve_star(user%factor,nounit,default,iprog%factor,error)
    if (error) return
  end subroutine cubetemplate_ext_twosubc2onesubc_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_ext_twosubc2onesubc_prog_act(prog,itersub,error)
    use cubeadm_subcube_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(ext_twosubc2onesubc_prog_t), intent(inout) :: prog
    type(subcube_iterator_t),          intent(in)    :: itersub
    logical,                           intent(inout) :: error
    !
    integer(kind=indx_k) :: ix,iy,iz
    type(subcube_t) :: insub1,insub2,ousub
    character(len=*), parameter :: rname='TWOSUBC2ONESUBC>PROG>ACT'
    !
    ! Subcubes are initialized here as their size (3rd dim) may change from
    ! from one subcube to another.
    call insub1%associate('insub1',prog%incube1,itersub,error)
    if (error) return
    call insub2%associate('insub2',prog%incube2,itersub,error)
    if (error) return
    call ousub%allocate('ousub',prog%oucube,itersub,error)
    if (error) return
    !
    call insub1%get(error)
    if (error) return
    call insub2%get(error)
    if (error) return
    do iz=1,insub1%nz
       do iy=1,insub1%ny
          do ix=1,insub1%nx
             ousub%val(ix,iy,iz) = prog%factor*insub1%val(ix,iy,iz)+insub2%val(ix,iy,iz)
          enddo ! ix
       enddo ! iy
    enddo ! iz
    call ousub%put(error)
    if (error) return
  end subroutine cubetemplate_ext_twosubc2onesubc_prog_act
  !
  !----------------------------------------------------------------------
  !
  function ext_twosubc2onesubc_user_ptr(user,error)
    !-------------------------------------------------------------------
    ! Check if the input class is of type(ext_twosubc2onesubc_user_t), and
    ! return a pointer to it if yes.
    !-------------------------------------------------------------------
    type(ext_twosubc2onesubc_user_t), pointer       :: ext_twosubc2onesubc_user_ptr
    class(two2one_user_t),            target        :: user
    logical,                          intent(inout) :: error
    !
    character(len=*), parameter :: rname='EXT>TWOSUBC2ONESUBC>USER>PTR'
    !
    select type(user)
    type is (ext_twosubc2onesubc_user_t)
      ext_twosubc2onesubc_user_ptr => user
    class default
      ext_twosubc2onesubc_user_ptr => null()
      call cubetemplate_message(seve%e,rname,  &
        'Internal error: object is not a ext_twosubc2onesubc_user_t type')
      error = .true.
      return
    end select
  end function ext_twosubc2onesubc_user_ptr
  !
  function ext_twosubc2onesubc_prog_ptr(prog,error)
    !-------------------------------------------------------------------
    ! Check if the input class is of type(ext_twosubc2onesubc_prog_t), and
    ! return a pointer to it if yes.
    !-------------------------------------------------------------------
    type(ext_twosubc2onesubc_prog_t), pointer       :: ext_twosubc2onesubc_prog_ptr
    class(two2one_prog_t),            target        :: prog
    logical,                          intent(inout) :: error
    !
    character(len=*), parameter :: rname='EXT>TWOSUBC2ONESUBC>PROG>PTR'
    !
    select type(prog)
    type is (ext_twosubc2onesubc_prog_t)
      ext_twosubc2onesubc_prog_ptr => prog
    class default
      ext_twosubc2onesubc_prog_ptr => null()
      call cubetemplate_message(seve%e,rname,  &
        'Internal error: object is not a ext_twosubc2onesubc_prog_t type')
      error = .true.
      return
    end select
  end function ext_twosubc2onesubc_prog_ptr
end module cubetemplate_twosubc2onesubc
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
