!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_spectrum2spectrum
  use cube_types
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubetemplate_sperange_types
  use cubetemplate_messaging
  !
  public :: spectrum2spectrum
  public :: cubetemplate_spectrum2spectrum_command
  private
  !
  type :: spectrum2spectrum_comm_t
     type(option_t), pointer :: comm
     type(option_t), pointer :: factor
     type(sperange_opt_t)    :: range     
   contains
     procedure, public  :: register => cubetemplate_spectrum2spectrum_register
     procedure, private :: parse    => cubetemplate_spectrum2spectrum_parse
     procedure, private :: main     => cubetemplate_spectrum2spectrum_main
  end type spectrum2spectrum_comm_t
  type(spectrum2spectrum_comm_t) :: spectrum2spectrum
  !
  integer(kind=4), parameter :: icube = 1
  type spectrum2spectrum_user_t
     type(cubeid_user_t)   :: cubeids
     type(sperange_user_t) :: range
     character(len=argu_l) :: factor
   contains
     procedure, private :: toprog => cubetemplate_spectrum2spectrum2spectrum_user_toprog
  end type spectrum2spectrum_user_t
  !
  type spectrum2spectrum_prog_t
     type(sperange_prog_t) :: range
     real(kind=sign_k)     :: factor
     type(cube_t), pointer :: incube
     type(cube_t), pointer :: oucube
   contains
     procedure, private :: header => cubetemplate_spectrum2spectrum_prog_header
     procedure, private :: data   => cubetemplate_spectrum2spectrum_prog_data
     procedure, private :: loop   => cubetemplate_spectrum2spectrum_prog_loop
     procedure, private :: act    => cubetemplate_spectrum2spectrum_prog_act
  end type spectrum2spectrum_prog_t
  !
contains
  !
  subroutine cubetemplate_spectrum2spectrum_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(spectrum2spectrum_user_t) :: user
    character(len=*), parameter :: rname='SPECTRUM2SPECTRUM>COMMAND'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call spectrum2spectrum%parse(line,user,error)
    if (error) return
    call spectrum2spectrum%main(user,error)
    if (error) continue
  end subroutine cubetemplate_spectrum2spectrum_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_spectrum2spectrum_register(spectrum2spectrum,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spectrum2spectrum_comm_t), intent(inout) :: spectrum2spectrum
    logical,                         intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: comm_abstract='Template to access input/output data per spectrum'
    character(len=*), parameter :: comm_help='Input and output cubes are real'
    character(len=*), parameter :: rname='SPECTRUM2SPECTRUM>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
!        'SPECTRUM2SPECTRUM','[cube]',& ! *** JP: SIC limitation?
         'SPEC2SPEC','[cube]',&
         comm_abstract,&
         comm_help,&
         cubetemplate_spectrum2spectrum_command,&
         spectrum2spectrum%comm,&
         error)
    if (error) return
    call cubearg%register(&
         'CUBE',&
         'Signal cube', &
         strg_id,&
         code_arg_optional, &
         [flag_any],&
         error)
    if (error) return
    !
    call spectrum2spectrum%range%register(&
         'RANGE',&
         'Define velocity range(s)',&
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'FACTOR','factor',&
         'Multiply data by a factor',&
         strg_id,&
         spectrum2spectrum%factor,error)
    if (error) return
    call stdarg%register(&
         'factor',&
         'Multiplicative factor',&
         'Default to 1.0',&
         code_arg_mandatory,&
         error)
    if (error) return
  end subroutine cubetemplate_spectrum2spectrum_register
  !
  subroutine cubetemplate_spectrum2spectrum_parse(spectrum2spectrum,line,user,error)
    !----------------------------------------------------------------------
    ! SPECTRUM cubname
    ! /RANGE vfirst vlast
    ! /FACTOR factor
    !----------------------------------------------------------------------
    class(spectrum2spectrum_comm_t), intent(in)    :: spectrum2spectrum
    character(len=*),                intent(in)    :: line
    type(spectrum2spectrum_user_t),  intent(out)   :: user
    logical,                         intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPECTRUM2SPECTRUM>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,spectrum2spectrum%comm,user%cubeids,error)
    if (error) return
    call spectrum2spectrum%range%parse(line,user%range,error)
    if (error) return
    call cubetemplate_spectrum2spectrum_parse_factor(line,spectrum2spectrum%factor,user%factor,error)
    if (error) return
  end subroutine cubetemplate_spectrum2spectrum_parse
  !
  subroutine cubetemplate_spectrum2spectrum_parse_factor(line,opt,user,error)
    !----------------------------------------------------------------------
    ! /FACTOR factor
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    type(option_t),   intent(in)    :: opt
    character(len=*), intent(out)   :: user
    logical,          intent(inout) :: error
    !
    logical :: present
    integer(kind=4), parameter :: iarg=1
    character(len=*), parameter :: rname='SPECTRUM2SPECTRUM>PARSE>FACTOR'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call opt%present(line,present,error)
    if (error) return
    if (present) then
       call cubetools_getarg(line,opt,iarg,user,mandatory,error)
       if (error) return
    else
       user = strg_star
    endif
  end subroutine cubetemplate_spectrum2spectrum_parse_factor
  !
  subroutine cubetemplate_spectrum2spectrum_main(comm,user,error) 
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spectrum2spectrum_comm_t), intent(in)    :: comm
    type(spectrum2spectrum_user_t),  intent(inout) :: user
    logical,                         intent(inout) :: error
    !
    type(spectrum2spectrum_prog_t) :: prog
    character(len=*), parameter :: rname='SPECTRUM2SPECTRUM>MAIN'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call user%toprog(comm,prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubetemplate_spectrum2spectrum_main
  !
  !------------------------------------------------------------------------
  !
  subroutine cubetemplate_spectrum2spectrum2spectrum_user_toprog(user,comm,prog,error)
    use cubetools_user2prog
    use cubetools_unit
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spectrum2spectrum_user_t), intent(in)    :: user
    type(spectrum2spectrum_comm_t),  intent(in)    :: comm    
    type(spectrum2spectrum_prog_t),  intent(out)   :: prog
    logical,                         intent(inout) :: error
    !
    type(unit_user_t) :: nounit
    real(kind=sign_k), parameter :: default=1.0
    character(len=*), parameter :: rname='SPECTRUM2SPECTRUM>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(comm%comm,icube,user%cubeids,&
         code_access_speset,code_read,prog%incube,error)
    if (error) return
    !
    call user%range%toprog(prog%incube,prog%range,error)
    if (error) return
    !
    call cubetools_unit_get(strg_star,unit_unk%id,nounit,error)
    if (error) return
    call cubetools_user2prog_resolve_star(user%factor,nounit,default,prog%factor,error)
    if (error) return
  end subroutine cubetemplate_spectrum2spectrum2spectrum_user_toprog
  !
  !------------------------------------------------------------------------
  !
  subroutine cubetemplate_spectrum2spectrum_prog_header(prog,error)
    use cubedag_allflags
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spectrum2spectrum_prog_t), intent(inout) :: prog
    logical,                         intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPECTRUM2SPECTRUM>PROG>HEADER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%incube,flag_template,prog%oucube,error)
    if (error) return
  end subroutine cubetemplate_spectrum2spectrum_prog_header
  !
  subroutine cubetemplate_spectrum2spectrum_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(spectrum2spectrum_prog_t), intent(inout) :: prog
    logical,                         intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='SPECTRUM2SPECTRUM>PROG>DATA'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error) exit
       !$OMP TASK SHARED(prog,error) FIRSTPRIVATE(iter)
       if (.not.error) &
         call prog%loop(iter%first,iter%last,error)
       !$OMP END TASK
    enddo
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubetemplate_spectrum2spectrum_prog_data
  !   
  subroutine cubetemplate_spectrum2spectrum_prog_loop(prog,first,last,error)
    use cubeadm_entryloop
    use cubeadm_spectrum_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spectrum2spectrum_prog_t), intent(inout) :: prog
    integer(kind=entr_k),            intent(in)    :: first
    integer(kind=entr_k),            intent(in)    :: last
    logical,                         intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(spectrum_t) :: input,output
    character(len=*), parameter :: rname='SPECTRUM2SPECTRUM>PROG>LOOP'
    !
    call input%associate('input',prog%incube,error)
    if (error) return
    call output%allocate('output',prog%oucube,error)
    if (error) return
    do ie=first,last
      call cubeadm_entryloop_iterate(ie,error)
      if (error) return
      call prog%act(ie,input,output,error)
      if (error) return
    enddo ! ie
  end subroutine cubetemplate_spectrum2spectrum_prog_loop
  !   
  subroutine cubetemplate_spectrum2spectrum_prog_act(prog,ie,input,output,error)
    use cubeadm_spectrum_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spectrum2spectrum_prog_t), intent(inout) :: prog
    integer(kind=entr_k),            intent(in)    :: ie
    type(spectrum_t),                intent(inout) :: input
    type(spectrum_t),                intent(inout) :: output
    logical,                         intent(inout) :: error
    !
    integer(kind=chan_k) :: ic
    character(len=*), parameter :: rname='SPECTRUM2SPECTRUM>PROG>ACT'
    !
    call input%get(ie,error)
    if (error) return
    do ic=1,input%n
      output%y%val(ic) = prog%factor*input%y%val(ic)
    enddo ! ic
    call output%put(ie,error)
    if (error) return
  end subroutine cubetemplate_spectrum2spectrum_prog_act
end module cubetemplate_spectrum2spectrum
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
